/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.api.fuel.IFuelRegistry;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public enum FuelRegistry implements IFuelRegistry
{
    INSTANCE;

    private static final FuelRecord MISSING_FUEL_ENTRY;
    private final Map<Fluid, FuelRecord> cachedFuels = new HashMap<Fluid, FuelRecord>();
    private final Map<Fluid, FuelRecord> hotFluids = new HashMap<Fluid, FuelRecord>();

    public static FuelRegistry getInstance() {
        return INSTANCE;
    }

    public void registerHotFluid(Fluid fluid, int mLPerBucket, float burnRateMultiplier) {
        this.hotFluids.put(fluid, new FuelRecord(mLPerBucket, burnRateMultiplier));
    }

    @Override
    public int getFuelValue(Level world, Fluid fluid) {
        return this.cachedFuels.computeIfAbsent((Fluid)fluid, (Function<Fluid, FuelRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFuelValue$0(net.minecraft.world.level.Level net.minecraft.world.level.material.Fluid net.minecraft.world.level.material.Fluid ), (Lnet/minecraft/world/level/material/Fluid;)Lme/desht/pneumaticcraft/common/fluid/FuelRegistry$FuelRecord;)((FuelRegistry)this, (Level)world, (Fluid)fluid)).mLperBucket;
    }

    @Override
    public float getBurnRateMultiplier(Level world, Fluid fluid) {
        return this.cachedFuels.computeIfAbsent((Fluid)fluid, (Function<Fluid, FuelRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBurnRateMultiplier$1(net.minecraft.world.level.Level net.minecraft.world.level.material.Fluid net.minecraft.world.level.material.Fluid ), (Lnet/minecraft/world/level/material/Fluid;)Lme/desht/pneumaticcraft/common/fluid/FuelRegistry$FuelRecord;)((FuelRegistry)this, (Level)world, (Fluid)fluid)).burnRateMultiplier;
    }

    @Override
    public Collection<Fluid> registeredFuels(Level world) {
        HashSet<Fluid> res = new HashSet<Fluid>(this.hotFluids.keySet());
        for (FuelQualityRecipe recipe : ModRecipeTypes.getRecipes(world, ModRecipeTypes.FUEL_QUALITY)) {
            res.addAll(recipe.getFuel().getFluidStacks().stream().map(FluidStack::getFluid).filter(f -> f.m_7444_(f.m_76145_())).toList());
        }
        return res;
    }

    public void clearCachedFuelFluids() {
        this.cachedFuels.clear();
    }

    private FuelRecord findEntry(Level world, Fluid fluid) {
        FuelRecord fe = this.hotFluids.get(fluid);
        if (fe != null) {
            return fe;
        }
        for (FuelQualityRecipe recipe : ModRecipeTypes.getRecipes(world, ModRecipeTypes.FUEL_QUALITY)) {
            if (!recipe.matchesFluid(fluid)) continue;
            return new FuelRecord(recipe.getAirPerBucket(), recipe.getBurnRate());
        }
        return MISSING_FUEL_ENTRY;
    }

    private /* synthetic */ FuelRecord lambda$getBurnRateMultiplier$1(Level world, Fluid fluid, Fluid k) {
        return this.findEntry(world, fluid);
    }

    private /* synthetic */ FuelRecord lambda$getFuelValue$0(Level world, Fluid fluid, Fluid k) {
        return this.findEntry(world, fluid);
    }

    static {
        MISSING_FUEL_ENTRY = new FuelRecord(0, 1.0f);
    }

    private record FuelRecord(int mLperBucket, float burnRateMultiplier) {
    }
}

